<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>SRI BALAJI SUPERMARKET - DAILY SETTELEMT REPORT</title>
    <style>
        @media  print {
            @page  {
                size: A4;
                margin: 10mm;
            }
            body {
                font-family: Arial, sans-serif;
                font-size: 11px;
            }
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #000;
            padding: 4px;
            text-align: right;
        }
        th:first-child,
        td:first-child {
            text-align: left;
        }
        h3 {
            margin: 0 0 10px 0;
            text-align: center;
        }
    </style>
</head>
<body onload="window.print()">
    <h3>SRI BALAJI SUPERMARKET - DAILY SETTELEMT REPORT
        <?php if(!empty($start_date) && !empty($end_date)): ?>
            (<?php echo e($start_date, false); ?> to <?php echo e($end_date, false); ?>)
        <?php endif; ?>
    </h3>

    <table>
        <thead>
            <tr>
                <th>User</th>
                <th>Cash sales</th>
                <th>Card sales (and card)</th>
                <th>GPay sales</th>
                <th>Sodexo Pluxee sales</th>
                <th>Credit sales</th>
                <th>Sales return</th>
                <th>Total sales</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $registers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $register): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($register->user_name, false); ?></td>
                    <td><?php echo e(number_format($register->total_cash_payment, 2), false); ?></td>
                    <td>
                        <?php echo e(number_format($register->total_card_payment, 2), false); ?>

                        (<?php echo e((int) $register->total_card_slips, false); ?>)
                    </td>
                    <td><?php echo e(number_format($register->total_custom_pay_1, 2), false); ?></td>
                    <td><?php echo e(number_format($register->total_custom_pay_2, 2), false); ?></td>
                    <td><?php echo e(number_format($register->credit_sale, 2), false); ?></td>
                    <td><?php echo e(number_format($register->sell_return, 2), false); ?></td>
                    <td><?php echo e(number_format($register->grand_total, 2), false); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <th>Total</th>
                <th><?php echo e(number_format($totals['cash'], 2), false); ?></th>
                <th><?php echo e(number_format($totals['card'], 2), false); ?></th>
                <th><?php echo e(number_format($totals['gpay'], 2), false); ?></th>
                <th><?php echo e(number_format($totals['sodexo'], 2), false); ?></th>
                <th><?php echo e(number_format($totals['credit_sale'], 2), false); ?></th>
                <th><?php echo e(number_format($totals['sell_return'], 2), false); ?></th>
                <th><?php echo e(number_format($totals['grand_total'], 2), false); ?></th>
            </tr>
        </tfoot>
    </table>

    <?php
        $denoms = !empty($cash_denominations) ? $cash_denominations : ['2000', '1000', '500', '200', '100', '50', '20', '10'];
        $allowed_users = ['c1', 'c2', 'c3'];
        $filtered_registers = collect($registers)
            ->filter(function ($r) use ($allowed_users) {
                return in_array(strtolower(trim($r->user_name)), $allowed_users, true);
            })
            ->take(3);
    ?>
    <div class="denomination-section" style="margin-top: 24px;">
        <?php $__currentLoopData = $filtered_registers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $register): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="user-denomination" style="margin-bottom: 28px; page-break-inside: avoid;">
            <h4 style="margin: 0 0 6px 0; font-size: 12px;"><?php echo e($register->user_name, false); ?> – Cash denomination</h4>
            <?php $__currentLoopData = $denoms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dnm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div style="margin: 4px 0; font-size: 11px;"><?php echo e($dnm, false); ?> * _____________</div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div style="margin-top: 10px; font-size: 11px;">Denomination Total: _____________</div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</body>
</html>

<?php /**PATH F:\xampp\htdocs\balaji-supermarket\resources\views/report/register_report_print.blade.php ENDPATH**/ ?>