<?php if(!session('business.enable_price_tax')): ?> 
  <?php
    $default = 0;
    $class = 'hide';
  ?>
<?php else: ?>
  <?php
    $default = null;
    $class = '';
  ?>
<?php endif; ?>

<div class="col-sm-12"><br>
    <div class="table-responsive">
    <table class="table table-bordered add-product-price-table table-condensed <?php echo e($class, false); ?>">
        <tr>
          <th><?php echo app('translator')->getFromJson('product.default_purchase_price'); ?></th>
          <th><?php echo app('translator')->getFromJson('product.profit_percent'); ?> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('tooltip.profit_percent') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?></th>
          <th><?php echo app('translator')->getFromJson('product.default_selling_price'); ?> (MRP)</th>
          <th>Discount</th>
          <th>Final Sell Price</th>
          <?php if(empty($quick_add)): ?>
            <th hidden><?php echo app('translator')->getFromJson('lang_v1.product_image'); ?></th>
          <?php endif; ?>
        </tr>
        <?php $__currentLoopData = $product_deatails->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($loop->first): ?>
                <tr>
                    <td>
                        <input type="hidden" name="single_variation_id" value="<?php echo e($variation->id, false); ?>">

                        <div class="col-sm-6">
                          <?php echo Form::label('single_dpp', trans('product.exc_of_tax') . ':*'); ?>


                          <?php echo Form::text('single_dpp', number_format($variation->default_purchase_price, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'form-control input-sm dpp input_number', 'placeholder' => __('product.exc_of_tax'), 'required']);; ?>

                        </div>

                        <div class="col-sm-6">
                          <?php echo Form::label('single_dpp_inc_tax', trans('product.inc_of_tax') . ':*'); ?>

                        
                          <?php echo Form::text('single_dpp_inc_tax', number_format($variation->dpp_inc_tax, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'form-control input-sm dpp_inc_tax input_number', 'placeholder' => __('product.inc_of_tax'), 'required']);; ?>

                        </div>
                    </td>

                    <td>
                        <br/>
                        <?php echo Form::text('profit_percent', number_format($variation->profit_percent, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'form-control input-sm input_number', 'id' => 'profit_percent', 'required']);; ?>

                    </td>

                    <td>
                        <label><span class="dsp_label"></span></label>
                        <?php echo Form::text('single_dsp', number_format($variation->default_sell_price, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'form-control input-sm dsp input_number', 'placeholder' => __('product.exc_of_tax'), 'id' => 'single_dsp', 'required']);; ?>


                        <?php echo Form::text('single_dsp_inc_tax', number_format($variation->sell_price_inc_tax, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'form-control input-sm hide input_number', 'placeholder' => __('product.inc_of_tax'), 'id' => 'single_dsp_inc_tax', 'required']);; ?>

                    </td>
                    
                    
                    
        <td>
            <select class="form-control input-sm" name="weight" id="weight">
                <?php 
                    $s=!empty($product->weight) ? $product->weight : '';
                ?>
                <option <?php if($s=="percentage"){ echo "selected";} ?> value="percentage">Percentage</option>
                <option value="fixed" <?php if($s=="fixed"){ echo "selected";} ?>>Fixed</option>
                
            </select>
          <?php echo Form::number('product_custom_field1', !empty($product->product_custom_field1) ? $product->product_custom_field1 : null, ['class' => 'form-control input-sm', 'id' => 'product_custom_field1','placeholder' => $product_custom_field1]);; ?>

          </td>
          <td>
              <input class="form-control input-sm input_number valid" placeholder="Sell Net Rate" id="sell_net_rate" required="" name="sell_net_rate" type="text" value="0" >
        </td>
                    
                    
                    
                    
                    
                    <td>
                        <?php 
                            $action = !empty($action) ? $action : '';
                        ?>
                        <?php if($action !== 'duplicate'): ?>
                            <?php $__currentLoopData = $variation->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="img-thumbnail">
                                    <span class="badge bg-red delete-media" data-href="<?php echo e(action('ProductController@deleteMedia', ['media_id' => $media->id]), false); ?>"><i class="fas fa-times"></i></span>
                                    <?php echo $media->thumbnail(); ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <div class="form-group" hidden>
                            <?php echo Form::label('variation_images', __('lang_v1.product_image') . ':'); ?>

                            <?php echo Form::file('variation_images[]', ['class' => 'variation_images', 'accept' => 'image/*', 'multiple']);; ?>

                            <small><p class="help-block"><?php echo app('translator')->getFromJson('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)]); ?> <br> <?php echo app('translator')->getFromJson('lang_v1.aspect_ratio_should_be_1_1'); ?></p></small>
                        </div>
                    </td>
                </tr>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    </div>
</div>

<script type="text/javascript">
    $(document).ready( function(){
        var single_dsp_inc_tax = __read_number($('input#single_dsp_inc_tax'));
        var disc_type = $('select#weight').val();
        var disc_amount = __read_number($('#product_custom_field1'));

        if(disc_type=="fixed"){
            $('#sell_net_rate').val(single_dsp_inc_tax-disc_amount);
        }else{
            $('#sell_net_rate').val(single_dsp_inc_tax-(single_dsp_inc_tax/100)*disc_amount);
        }

      
$(document).on('change', 'input#single_dpp,input#single_dpp_inc_tax,input#profit_percent,input#single_dsp_inc_tax,input#product_custom_field1,select#weight,select#tax', function(e) {
        console.log('oooo');
        var single_dsp_inc_tax = __read_number($('input#single_dsp_inc_tax'));
        var disc_type = $('select#weight').val();
        var disc_amount = __read_number($('#product_custom_field1'));

        if(disc_type=="fixed"){
            $('#sell_net_rate').val(single_dsp_inc_tax-disc_amount);
        }else{
            $('#sell_net_rate').val(single_dsp_inc_tax-(single_dsp_inc_tax/100)*disc_amount);
        }
  
    });
    
    $(document).on('change', 'input#sell_net_rate', function(e) {
        console.log('oooo111');
        var single_dsp_inc_tax = __read_number($('input#single_dsp_inc_tax'));
        var sell_net_rate = __read_number($('input#sell_net_rate'));
        var disc_type = $('select#weight').val();
      
        if(disc_type=="fixed"){
            $('#product_custom_field1').val(single_dsp_inc_tax-sell_net_rate);
        }else{
            $('#product_custom_field1').val(((single_dsp_inc_tax-sell_net_rate)/single_dsp_inc_tax)*100);
        }
  
    });
    });
</script><?php /**PATH /home/firstmatrixcoin/public_html/smart.firstmatrix.co.in/resources/views/product/partials/edit_single_product_form_part.blade.php ENDPATH**/ ?>