<style>
    @page {
  size: auto; 
  /* Chrome sets own margins, we change these printer settings */
  margin: 2mm 3mm -2mm 5mm; 
}
</style>
<script src="https://code.jquery.com/jquery-1.9.1.js"></script>
<script>
    $(document).ready(function() {
       window.print();
  setTimeout(window.close, 0);
    });
</script>
<!-- business information here -->
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <!-- <link rel="stylesheet" href="style.css"> -->
        <title>Receipt-{{$receipt_details->invoice_no}}</title>
    </head>
    <body>
			 <div class="ticket"><p class="centered">   @if(!empty($receipt_details->display_name))
					<span class="headings" style="font-size:24px;">
						{{$receipt_details->display_name}}
					</span>
					<br/>
				@endif
			    </p>
			    <table style="width:100%">
			    
			
			@if(empty($receipt_details->invoice_no_prefix))
			    <tr>
			        <td colspan="2" class="f-left"><strong>@if(!empty($receipt_details->invoice_no_prefix)){!! $receipt_details->invoice_no_prefix !!} @endif @if(empty($receipt_details->invoice_no_prefix)) Order No @endif : {{$receipt_details->invoice_no}}</strong></td>
			    </tr>
			    <tr>
			        <td colspan="2" class="f-left"><strong>@if(empty($receipt_details->invoice_no_prefix)) Order @endif{!! $receipt_details->date_label !!}</strong> {{$receipt_details->sell_custom_field_1_value}}	</td>

			    </tr>

		    @endif	
		    @if(!empty($receipt_details->invoice_no_prefix))
			    <tr>
			        <td class="f-left"><strong>@if(!empty($receipt_details->invoice_no_prefix)){!! $receipt_details->invoice_no_prefix !!} @endif @if(empty($receipt_details->invoice_no_prefix)) O.No @endif : {{$receipt_details->invoice_no}}</strong></td>
			        <td class="f-right"><strong>{!! $receipt_details->date_label !!}</strong>
			        
			        <?php $old_date_timestamp = strtotime($receipt_details->invoice_date);
$new_date = date('d/m/Y h:i A', $old_date_timestamp); ?>
			        {{$new_date}}</td>
			    </tr>
			    
		    @endif	
			</table>
			<div class="flex-box">
					<p class="width-100 text-center main-headings">
						BILL AMT :{{$receipt_details->total}}
					</p>
					
				</div>
		 {{-- Barcode --}}
			@if($receipt_details->show_barcode)
				<img class="center-block" src="data:image/png;base64,{{DNS1D::getBarcodePNG($receipt_details->invoice_no, 'C128', 2,30,array(39, 48, 54), true)}}">
			@endif	
	</div>		
        <!-- <button id="btnPrint" class="hidden-print">Print</button>
        <script src="script.js"></script> -->
    </body>
</html>

<style type="text/css">
.f-8 {
	font-size: 8px !important;
}
body {
	color: #000000;
}
@media print {
	* {
    	font-size: 14px;
    	font-weight:600;
    	font-family: 'Times New Roman';
    	word-break: break-all;
	}
	.f-8 {
		font-size: 12px !important;
	}
	
.headings{
	font-size: 20px;
	font-weight: 700;
	text-transform: uppercase;
	white-space: nowrap;
}

.sub-headings{
	font-size: 20px !important;
	font-weight: 700 !important;
}
.main-headings{
	font-size: 22px !important;
	font-weight: 800 !important;
}


.border-top{
    border-top: 1px solid black;
}
.border-bottom{
	border-bottom: 1px solid black;
}

.border-bottom-dotted{
	border-bottom: 1px dotted black;
}
.border-top-dotted{
	border-top: 1px dotted black;
}

td.serial_number, th.serial_number{
	width: 5%;
    max-width: 5%;
}

td.description,
th.description {
    width: 35%;
    max-width: 35%;
}

td.quantity,
th.quantity {
    width: 15%;
    max-width: 15%;
    word-break: break-all;
}
td.unit_price, th.unit_price{
	width: 25%;
    max-width: 25%;
    word-break: break-all;
}

td.price,
th.price {
    width: 20%;
    max-width: 20%;
    word-break: break-all;
}

.centered {
    text-align: center;
    align-content: center;
}

.ticket {
    width: 100%;
    max-width: 100%;
}

img {
    max-width: inherit;
    width: auto;
}

    .hidden-print,
    .hidden-print * {
        display: none !important;
    }
}
.table-info {
	width: 100%;
}
.table-info tr:first-child td, .table-info tr:first-child th {
	padding-top: 8px;
}
.table-info th {
	text-align: left;
}
.table-info td {
	text-align: right;
}
.logo {
	float: left;
	width:35%;
	padding: 10px;
}

.text-with-image {
	float: left;
	width:65%;
}
.text-box {
	width: 100%;
	height: auto;
}

.textbox-info {
	clear: both;
}
.textbox-info p {
	margin-bottom: 0px
}
.flex-box {
	display: flex;
	width: 100%;
	padding-right:15px;
}
.flex-box p {
	width: 50%;
	margin-bottom: 0px;
	white-space: nowrap
	padding-right:15px;
}

.table-f-12 th, .table-f-12 td {
	font-size: 12px;
	word-break: break-word;
}

.bw {
	word-break: break-word;
}
</style> 